import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { AnnualInspectionAuditVO, AnnualInspectionAuditForm, AnnualInspectionAuditQuery } from '@/api/annualInspection/annualInspectionAudit/types';

/**
 * 查询年检管理列表
 * @param query
 * @returns {*}
 */

export const listAnnualInspectionAudit = (query?: any): AxiosPromise<AnnualInspectionAuditVO[]> => {
  return request({
    url: '/zjk-api/annualInspectionAudit/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询年检管理详细
 * @param id
 */
export const getAnnualInspectionAudit = (id: string | number): AxiosPromise<AnnualInspectionAuditVO> => {
  return request({
    url: '/zjk-api/annualInspectionAudit/' + id,
    method: 'get'
  });
};

/**
 * 新增年检管理
 * @param data
 */
export const addAnnualInspectionAudit = (data: AnnualInspectionAuditForm) => {
  return request({
    url: '/zjk-api/annualInspectionAudit',
    method: 'post',
    data: data
  });
};

/**
 * 修改年检管理
 * @param data
 */
export const updateAnnualInspectionAudit = (data: AnnualInspectionAuditForm) => {
  return request({
    url: '/zjk-api/annualInspectionAudit',
    method: 'put',
    data: data
  });
};

/**
 * 删除年检管理
 * @param id
 */
export const delAnnualInspectionAudit = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk-api/annualInspectionAudit/delete/' + id,
    method: 'get'
  });
};

/**
 * 批量年检
 * @param data
 */
export const batchAnnualInspection = (data: AnnualInspectionAuditForm) => {
  return request({
    url: '/zjk-api/annualInspectionAudit/batchAnnualInspection',
    method: 'post',
    data: data
  });
};
