export interface AnnualInspectionAuditVO {
  /**
   * id
   */
  id: string | number;

  /**
   * 用户 id
   */
  userId: string | number;

  /**
   * 专家 id
   */
  expertId: string | number;

  /**
   * 年检编号
   */
  annualInspectionSn: string;

  /**
   * 年检名称
   */
  annualInspectionName: string;

  /**
   * 审核方式(1 人工年检 2 自动年检)
   */
  annualInspectionType: string;

  /**
   * 年检状态(1 待年检 2 已通过 3 未通过)
   */
  annualInspectionStatus: string;

  /**
   * 原因
   */
  reason: string;

  /**
   * 审核时间
   */
  auditTime: string;

}

export interface AnnualInspectionAuditForm extends BaseEntity {
  /**
   * id
   */
  id?: string | number;

  /**
   * 用户 id
   */
  userId?: string | number;

  /**
   * 专家 id
   */
  expertId?: string | number;

  /**
   * 年检编号
   */
  annualInspectionSn?: string;

  /**
   * 年检名称
   */
  annualInspectionName?: string;

  /**
   * 审核方式(1 人工年检 2 自动年检)
   */
  annualInspectionType?: string;

  /**
   * 年检状态(1 待年检 2 已通过 3 未通过)
   */
  annualInspectionStatus?: string;

  /**
   * 原因
   */
  reason?: string;

  /**
   * 审核时间
   */
  auditTime?: string;

  /**
   * ID 集合
   */
  ids?: Array<string | number>;
}

export interface AnnualInspectionAuditQuery extends PageQuery {

  /**
   * 用户 id
   */
  userId?: string | number;

  /**
   * 专家 id
   */
  expertId?: string | number;
  /**
   * 专家 id
   */
  contact?: string | number;

  /**
   * 年检编号
   */
  annualInspectionSn?: string;

  /**
   * 年检名称
   */
  annualInspectionName?: string;

  /**
   * 原因
   */
  reason: string;

  /**
   * 审核方式(1 人工年检 2 自动年检)
   */
  annualInspectionType?: string;

  /**
   * 年检状态(1 待年检 2 已通过 3 未通过)
   */
  annualInspectionStatus?: string;

  /**
   * 审核时间
   */
  auditTime?: string;

    /**
     * 日期范围参数
     */
    params?: any;
  dateRangeAuditTime?: string[]
}



