import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { AnnualInspectionRecordsVO, AnnualInspectionRecordsForm, AnnualInspectionRecordsQuery } from '@/api/annualInspection/annualInspectionRecords/types';

/**
 * 查询年检记录列表
 * @param query
 * @returns {*}
 */

export const listAnnualInspectionRecords = (query?: AnnualInspectionRecordsQuery): AxiosPromise<AnnualInspectionRecordsVO[]> => {
  return request({
    url: '/zjk-api/annualInspectionRecords/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询年检记录详细
 * @param id
 */
export const getAnnualInspectionRecords = (id: string | number): AxiosPromise<AnnualInspectionRecordsVO> => {
  return request({
    url: '/zjk-api/annualInspectionRecords/' + id,
    method: 'get'
  });
};

/**
 * 新增年检记录
 * @param data
 */
export const addAnnualInspectionRecords = (data: AnnualInspectionRecordsForm) => {
  return request({
    url: '/zjk-api/annualInspectionRecords',
    method: 'post',
    data: data
  });
};

/**
 * 修改年检记录
 * @param data
 */
export const updateAnnualInspectionRecords = (data: AnnualInspectionRecordsForm) => {
  return request({
    url: '/zjk-api/annualInspectionRecords',
    method: 'put',
    data: data
  });
};

/**
 * 删除年检记录
 * @param id
 */
export const delAnnualInspectionRecords = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk-api/annualInspectionRecords/' + id,
    method: 'delete'
  });
};
