import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import {CountVO,} from '@/api/backStage/expertManagement/expertStatisticalReport/types';

/**
 * 专家类型统计
 * @param query
 * @returns {*}
 */

export const getExpertUnitTypeData = (): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expert/getUnitCount',
    method: 'get'
  });
};

/**
 * 专家入库错误分析
 * @param query
 * @returns {*}
 */

export const getExpertErrorSts = (): AxiosPromise<any> => {
  return request({
    url: '/system/operlog/expertErrorSts',
    method: 'get'
  });
};

/**
 * 专家参与项目 tpo5
 * @param query
 * @returns {*}
 */

export const getExpertJoinProjectData = (): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/project/extract/expert/top5',
    method: 'get'
  });
};

/**
 * 专家信用等级统计
 * @param query
 * @returns {*}
 */

export const getExpertCreditRatingData = (): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/creditLv/list',
    method: 'get'
  });
};

/**
 * 专家工作年限统计
 * @param query
 * @returns {*}
 */

export const getExpertWorkExperienceData = (): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expert/workProfessialYear',
    method: 'get'
  });
};

/**
 * 专家研究领域统计
 * @param query
 * @returns {*}
 */

export const getExpertResearchFieldData = (query): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expert/getExpertPerformWorkCount',
    method: 'get',
    params: query
  });
};

/**
 * 专家学历统计
 * @param query
 * @returns {*}
 */

export const getExpertEducationData = (): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expertMajor/getExpertMajorCount',
    method: 'get'
  });
};

