import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { ExpertVO, ExpertForm, ExpertQuery } from '@/api/expert/expert/types';

/**
 * 专家查找expert列表
 * @param query
 * @returns {*}
 */

export const queryProList = (): AxiosPromise<[]> => {
  return request({
    url: '/zjk-api/expertProfessional/professionalList',
    method: 'get'
  });
};

/**
 * 专家查找expert列表
 * @param query
 * @returns {*}
 */

export const queryExpert = (data): AxiosPromise<ExpertVO[]> => {
  return request({
    url: '/zjk-api/expert/expertInquiry',
    method: 'get',
    params: data
  });
};

/**
 * 查询expert列表
 * @param query
 * @returns {*}
 */

export const listExpert = (query?: ExpertQuery): AxiosPromise<ExpertVO[]> => {
  return request({
    url: '/zjk-api/expert/expertList',
    method: 'get',
    params: query
  });
};

/**
 * 查询expert详细
 * @param id
 */
export const getExpert = (id: string | number): AxiosPromise<ExpertVO> => {
  return request({
    url: '/zjk-api/expert/' + id,
    method: 'get'
  });
};

/**
 * 新增expert
 * @param data
 */
export const addExpert = (data: ExpertForm) => {
  return request({
    url: '/zjk-api/expert/save',
    method: 'post',
    data: data
  });
};

/**
 * 用户输入错误次数统计
 */
export const sendUserInputError = (data: any) => {
  return request({
    url: '/system/operlog/saveLog',
    method: 'post',
    data
  });
}

/**
 * 修改expert
 * @param data
 */
export const updateExpert = (data: ExpertForm) => {
  return request({
    url: '/zjk-api/expert/update',
    method: 'post',
    data: data
  });
};

/**
 * 删除expert
 * @param id
 */
export const delExpert = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk-api/expert/delete/' + id,
    method: 'get'
  });
};
/**
 * 手动移入黑名单
 * @param id
 */
export const moveToBlack = (data) => {
  return request({
    url: '/zjk-api/creditUser/moveToBlacklist',
    method: 'post',
    data
  });
};
/**
 * 手动移出黑名单
 * @param id
 */
export const moveBackBlack = (data) => {
  return request({
    url: '/zjk-api/creditUser/removeTheBlacklist',
    method: 'post',
    data
  });
};

export const getFile = (ossId?: string): AxiosPromise<any[]> => {
  return request({
    url: `/resource/oss/listByIds/${ossId}`,
    method: 'get'
  });
};
