import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { PersonVO, PersonForm, PersonQuery } from '@/api/expert/person/types';

/**
 * 撤销
 * @param query
 * @returns {*}
 */

export const repeal = (): AxiosPromise<PersonVO> => {
  return request({
    url: '/zjk-api/expert/expertQuash',
    method: 'get'
  });
};

/**
 * 查询expert列表
 * @param query
 * @returns {*}
 */

export const listPerson = (query?: PersonQuery): AxiosPromise<PersonVO[]> => {
  return request({
    url: '/zjk-api/expert/list',
    method: 'get',
    params: query
  });
};
//获取合作项目列表
export const listCooProject = (params) => {
  return request({
    url: '/zjk-api/reviewPhase/getReviewProductListByExpert' ,
    method: 'get',
    params
  });
};
//获取评价反馈列表
export const listFeedBack = (params) => {
  return request({
    url: '/zjk-api/evaluate/getEvaluateListByExpert' ,
    method: 'get',
    params
  });
};

/**
 * 查询person详细
 * @param id
 */
// export const getPerson = (data): AxiosPromise<PersonVO> => {
//   return request({
//     url: '/zjk-api/expert/getInfo' ,
//     method: 'post',
//     data
//   });
// };
export const getPerson = (id: string | number): AxiosPromise<PersonVO> => {
  return request({
    url: '/zjk-api/expert/getUserInfo',
    // url: '/zjk-api/expert/getUserInfo/' + id,
    method: 'get'
  });
};
//年检获取专家详情
export const getInspectionPerson = (data) => {
  return request({
    url: '/zjk-api/expert/getExpertInfo',
    method: 'post',
    data
  });
};

/**
 * 新增expert
 * @param data
 */
export const addPerson = (data: PersonForm) => {
  return request({
    url: '/zjk-api/expert/save',
    method: 'post',
    data: data
  });
};

/**
 * 修改expert
 * @param data
 */
export const updatePerson = (data: PersonForm) => {
  return request({
    url: '/zjk-api/expert/update',
    method: 'post',
    data: data
  });
};

/**
 * 删除expert
 * @param id
 */
export const delPerson = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk-api/expert/delete/' + id,
    method: 'get'
  });
};

/**
 * 离职申请
 * @param id
 */
export const toResign = (data) => {
  return request({
    url: '/zjk-api/retirementRecords/add',
    method: 'post',
    data
  });
};

//获取职称等级列表
export const listPosition = () => {
  return request({
    url: '/zjk-api/expertMoneyConfig/getExpertMoneyConfig',
    method: 'get'
  });
};