import request from '@/utils/request';
import { AxiosPromise } from 'axios';

export const getTableList = (params?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expertMoneyConfig/list',
    method: 'get',
    params
  });
};

export const deleteManage = (id: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expertMoneyConfig/remove/' + id,
    method: 'get'
  });
};

export const addManage = (data: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expertMoneyConfig/add',
    method: 'post',
    data
  });
};

export const updateManage = (data: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/expertMoneyConfig/edit\n',
    method: 'post',
    data
  });
};
