export interface LearningInformationVO {
  /**
   * id
   */
  id: string | number;

  /**
   * 资讯类型
   */
  informationClassifyId: string | number;

  /**
   * 资讯封面
   */
  informationImage: string;

  /**
   * 资讯封面Url
   */
  informationImageUrl: string;
  /**
   * 资讯标题
   */
  informationTitle: string;

  /**
   * 资讯详情
   */
  informationDetail: string;

  /**
   * 状态
   */
  status: string;

  /**
   * 备注
   */
  remark: string;

  /**
   * 用户id
   */
  userId: string | number;

}

export interface LearningInformationForm extends BaseEntity {
  /**
   * id
   */
  id?: string | number;

  /**
   * 资讯类型
   */
  informationClassifyId?: string | number;

  /**
   * 资讯封面
   */
  informationImage?: string;

  /**
   * 资讯标题
   */
  informationTitle?: string;

  /**
   * 资讯详情
   */
  informationDetail?: string;

  /**
   * 状态
   */
  status?: string;

  /**
   * 备注
   */
  remark?: string;

  /**
   * 用户id
   */
  userId?: string | number;

}

export interface LearningInformationQuery extends PageQuery {

  /**
   * 资讯类型
   */
  informationClassifyId?: string | number;

  /**
   * 资讯封面
   */
  informationImage?: string;

  /**
   * 资讯标题
   */
  informationTitle?: string;

  /**
   * 资讯详情
   */
  informationDetail?: string;

  /**
   * 状态
   */
  status?: string;

  /**
   * 用户id
   */
  userId?: string | number;

    /**
     * 日期范围参数
     */
    params?: any;
}



