export interface PlanQuery {

  /**
   * 计划名称
   */
  planName: string;
}

export interface PlanVO {
  /**
   * expertId
   */
  id: string | number;

  /**
   * 计划名称
   */
  planName: string;

  /**
   * 学习目标
   */
  studyTarget: string;

  /**
   * 计划执行开始时间
   */
  startTime: string;

  /**
   * 计划执行截止时间
   */
  endTime: string;

  /**
   * 学习内容
   */
  courseNames: string | Array<any>;
}

interface FormType {
  planName: string;
  date: Array<string>;
  studyTarget: string;
  content: Array<{
    classify: string | number;
    courseName: string | number;
    courseLists: Array<any>;
  }>;
}

interface RulesType {
  planName: Array<{ required: boolean; message: string; trigger: string }>;
  date: Array<{ required: boolean; message: string; trigger: string }>;
  studyTarget: Array<{ required: boolean; message: string; trigger: string }>;
  classify: Array<{ required: boolean; message: string; trigger: string }>;
  courseName: Array<{ required: boolean; message: string; trigger: string }>;
}

export interface StateData {
  form: FormType;
  rules: RulesType;
}

