import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { ExpertRecommendVO, ExpertRecommendForm, ExpertRecommendQuery } from '@/api/expert/expertRecommend/types';

/**
 * 查询专家推荐记录
 * @param query
 * @returns {*}
 */

export const listRecommendRecord = (query?: ExpertRecommendQuery): AxiosPromise<ExpertRecommendVO[]> => {
  return request({
    url: '/zjk-api/expertRecommend/queryExpertRecommendList',
    method: 'get',
    params: query
  });
};

/**
 * 查询专家推荐信息列表
 * @param query
 * @returns {*}
 */

export const listExpertRecommend = (query?: ExpertRecommendQuery): AxiosPromise<ExpertRecommendVO[]> => {
  return request({
    url: '/zjk-api/expertRecommend/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询专家推荐信息详细
 * @param id
 */
export const getExpertRecommend = (id: string | number): AxiosPromise<ExpertRecommendVO> => {
  return request({
    url: '/zjk-api/expertRecommend/' + id,
    method: 'get'
  });
};

/**
 * 新增专家推荐信息
 * @param data
 */
export const addExpertRecommend = (data: ExpertRecommendForm) => {
  return request({
    url: '/zjk-api/expertRecommend',
    method: 'post',
    data: data
  });
};

/**
 * 修改专家推荐信息
 * @param data
 */
export const updateExpertRecommend = (data: ExpertRecommendForm) => {
  return request({
    url: '/zjk-api/expertRecommend',
    method: 'put',
    data: data
  });
};

/**
 * 删除专家推荐信息
 * @param id
 */
export const delExpertRecommend = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk-api/expertRecommend/' + id,
    method: 'delete'
  });
};
