import request from '@/utils/request';
import { AxiosPromise } from 'axios';

export const getProjectSelList = (productName): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/product/listByName`,
    method: 'get',
    params: {
      productName
    }
  });
};
export const getTableList = (query?: any): AxiosPromise<any[]> => {
  return request({
    url: `/zjk-api/product/select/list`,
    method: 'get',
    params: query
  });
};
export const getDetail = (id?: any): AxiosPromise<any[]> => {
  return request({
    url: `/zjk-api/product/select/productId/reviewSn/${id}`,
    method: 'get'
  });
};

export const delList = (id: any): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/product/remove/productId/reviewSn/${id}`,
    method: 'get'
  });
};
export const getFile = (ossId?: string): AxiosPromise<any[]> => {
  return request({
    url: `/resource/oss/listByIds/${ossId}`,
    method: 'get'
  });
};
export const addProjectFile = (query): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/product/add',
    method: 'post',
    data: query
  });
};
export const updateProjectFile = (query): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/product/productReview/update',
    method: 'post',
    data: query
  });
};

export const getProjectFileList = (query?: any): AxiosPromise<any[]> => {
  return request({
    url: `/zjk-api/productReviewsn/list`,
    method: 'get',
    params: query
  });
};
export const getExpertFileList = (query?: any): AxiosPromise<any[]> => {
  return request({
    url: `/zjk-api/expertPaper/list`,
    method: 'get',
    params: query
  });
};
