export interface ExtractQuery {
  itemName: string | number;
  itemCode: string;
  extractionStatus: string | number;
  extractDate: Array<string> | string;
  startExtractionTime?: string;
  endExtractionTime?: string;
  pageNum?: number,
  pageSize?: number
}

export interface ExtractVO extends ExtractQuery {
  id: string;
  extractionCount: string | number;
  expertSum: string | number;
  extractedSum: string | number;
  extractionUser: string;
  extractionTime: string;
  zjkProductVo: any;
  zjkReviewPhase: any;
  projectName?: string;
  productSn?: string;
  reviewSn?: string
}

export interface ExtractFormTypes {
  reviewSn: string;
  reviewPlace: string;
  reviewTime: string;
  count: number;
  mode: string | number;
  expertsCout: number;
  expertsId: string[] | number[];
  extractioRestrictio: string[] | number[];
  isAvoid: boolean;
  expertIds: string[] | number[];
  unit: string[] | number[];
  extractedSum: string | number;
  supplementNum: number;
  extractArea: string[] | number[];
  areaList: Array<any>;
}
export interface ResultListType {
  id: string | number;
  expertName: string;
  projectConcatphone: string | number;
  unit: string;
  job: string;
  major: string;
  education: string;
  expertStatus: string | number;

}

export interface ProjectFormType {
  projectId: string | number;
  productName: string;
  productType: string;
  productScale: string;
  productUnit: string;
  unitBy: string;
  contact: string;
}

export interface ProjectRulesType {
  projectId: Array<object>;
  productType: Array<object>;
  productScale: Array<object>;
  productUnit: Array<object>;
  unitBy: Array<object>;
  contact: Array<object>;
}
export interface dictType {
  label: string;
  value: string;
}
