import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { ProjectVO, ProjectForm, ProjectQuery } from '@/api/project/review/types';

/**
 * 查询项目全景详细
 * @param id
 */
export const getProject = (params) => {
  return request({
    url: '/zjk-api/product/panorama-by-id',
    method: 'get',
    params
  });
};

/**
 * 查询项目详细
 * @param id
 */
export const getProjectDetail = (id: string | number): AxiosPromise<ProjectVO> => {
  return request({
    url: '/zjk/product/' + id,
    method: 'get'
  });
};

/**
 * 查找项目全景列表
 * @param query
 * @returns {*}
 */
export const projectList = (params): AxiosPromise<[]> => {
  return request({
    url: '/zjk-api/product/panorama',
    method: 'get',
    params
  });
};

export const unitList = (): AxiosPromise<[]> => {
  return request({
    url: '/zjk-api/product/panorama/dept',
    method: 'get'
  });
};

/**
 * 专家查找expert列表
 * @param query
 * @returns {*}
 */

export const queryExpert = (data): AxiosPromise<ProjectVO[]> => {
  return request({
    url: '/zjk-api/expert/expertInquiry',
    method: 'get',
    params : data
  });
};

/**
 * 查询expert列表
 * @param query
 * @returns {*}
 */

export const listExpert = (query?: ProjectQuery): AxiosPromise<ProjectVO[]> => {
  return request({
    url: '/zjk-api/expert/expertList',
    method: 'get',
    params: query
  });
};

