import request from '@/utils/request';
import { AxiosPromise } from 'axios';

export function getTableList(query: any): AxiosPromise<any[]> {
  return request({
    url: '/zjk-api/problem/list',
    method: 'get',
    params: query
  });
}
export function getQuestionList(query: any): AxiosPromise<any[]> {
  return request({
    url: '/zjk-api/problem/list',
    method: 'get',
    params: query
  });
}
export function getQuestionInfo(id: any): AxiosPromise<any[]> {
  return request({
    url: `/zjk-api/problem/${id}`,
    method: 'get'
  });
}

export const delQuestion = (query: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/problem/delete',
    method: 'post',
    data: query
  });
};

export const replyQuestion = (query: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/problem/reply',
    method: 'post',
    data: query
  });
};

export const submitQuestion = (query: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/problem/add',
    method: 'post',
    data: query
  });
};
