import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { LearningActivityVO, LearningActivityForm, LearningActivityQuery } from '@/api/study/activity/types';

/**
 * 查询活动管理列表
 * @param query
 * @returns {*}
 */

export const listLearningActivity = (query?: LearningActivityQuery): AxiosPromise<LearningActivityVO[]> => {
  return request({
    url: '/zjk/learningActivity/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询活动管理详细
 * @param id
 */
export const getLearningActivity = (id: string | number) => {
  return request({
    url: '/zjk/learningActivity/' + id,
    method: 'get'
  });
};

/**
 * 新增活动管理
 * @param data
 */
export const addLearningActivity = (data: LearningActivityForm) => {
  return request({
    url: '/zjk/learningActivity',
    method: 'post',
    data: data
  });
};

/**
 * 修改活动状态
 * @param data
 */
export const updateStatus = (data: LearningActivityForm) => {
  return request({
    url: '/zjk/learningActivity/update/status',
    method: 'post',
    data: data
  });
};

/**
 * 修改活动管理
 * @param data
 */
export const updateLearningActivity = (data: LearningActivityForm) => {
  return request({
    url: '/zjk/learningActivity/update',
    method: 'post',
    data: data
  });
};

/**
 * 删除活动管理
 * @param id
 */
export const delLearningActivity = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk/learningActivity/deleted/' + id,
    method: 'get'
  });
};
