export interface LearningActivityVO {
  /**
   * id
   */
  id: string | number;

  /**
   * 活动名称
   */
  activityName: string;

  /**
   * 活动分类
   */
  activityClassify: string;

  /**
   * 活动时间
   */
  activityTime: string;

  /**
   * 活动地点
   */
  activityAddress: string;

  /**
   * 活动数量
   */
  activityNum: number;

  /**
   * 封面图
   */
  activityPic: string;

  /**
   * 活动内容
   */
  activityContent: string;

  /**
   * 是否发布
   */
  isPublic: string;

  /**
   * 状态
   */
  status: string;

  /**
   * 备注
   */
  remark: string;

}

export interface LearningActivityForm extends BaseEntity {
  /**
   * id
   */
  id?: string | number;

  /**
   * 活动名称
   */
  activityName?: string;

  /**
   * 活动分类
   */
  activityClassify?: string;

  /**
   * 活动时间
   */
  activityTime?: string;

  /**
   * 活动地点
   */
  activityAddress?: string;

  /**
   * 活动数量
   */
  activityNum?: number;

  /**
   * 封面图
   */
  activityPic?: string;

  /**
   * 活动内容
   */
  activityContent?: string;

  /**
   * 是否发布
   */
  isPublic?: string;

  /**
   * 状态
   */
  status?: string;

  /**
   * 备注
   */
  remark?: string;

}

export interface LearningActivityQuery extends PageQuery {

  /**
   * 活动名称
   */
  activityName?: string;

  /**
   * 活动分类
   */
  activityClassify?: string;

  /**
   * 活动时间
   */
  activityTime?: string;

  /**
   * 活动地点
   */
  activityAddress?: string;

  /**
   * 活动数量
   */
  activityNum?: number;

  /**
   * 封面图
   */
  activityPic?: string;

  /**
   * 活动内容
   */
  activityContent?: string;

  /**
   * 是否发布
   */
  isPublic?: string;

  /**
   * 状态
   */
  status?: string;

    /**
     * 日期范围参数
     */
    params?: any;
}



