import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { LearningCommontVO, LearningCommontForm, LearningCommontQuery } from '@/api/study/comment/types';

/**
 * 查询评论列表
 * @param query
 * @returns {*}
 */

export const listLearningCommont = (query): AxiosPromise<LearningCommontVO[]> => {
  return request({
    url: '/zjk/learningCommont/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询评论详细
 * @param id
 */
export const getLearningCommont = (id: string | number): AxiosPromise<LearningCommontVO> => {
  return request({
    url: '/zjk/learningCommont/' + id,
    method: 'get'
  });
};

/**
 * 新增评论
 * @param data
 */
export const addLearningCommont = (data) => {
  return request({
    url: '/zjk/learningCommont',
    method: 'post',
    data: data
  });
};

/**
 * 修改评论
 * @param data
 */
export const updateStatus = (data: LearningCommontForm) => {
  return request({
    url: '/zjk/learningCommont/update/status',
    method: 'post',
    data: data
  });
};

/**
 * 修改评论
 * @param data
 */
export const updateLearningCommont = (data: LearningCommontForm) => {
  return request({
    url: '/zjk/learningCommont',
    method: 'put',
    data: data
  });
};

/**
 * 删除评论
 * @param id
 */
export const delLearningCommont = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk/learningCommont/deleted/' + id,
    method: 'get'
  });
};
