import request from '@/utils/request';
import { ResourceVO,ResourceQuery } from './types';
import { AxiosPromise } from 'axios';

// 查询社区人数
export function getPersonCount() {
  return request({
    url: '/zjk-api/expert/getExpertCount',
    method: 'get'
  });
}

// 查询帖子数量
export function getTopicCount() {
  return request({
    url: '/zjk-api/learningInformation/getCount',
    method: 'get'
  });
}

// 查询社区
export function getCommunity() {
  return request({
    url: '/zjk-api/learningCommunity',
    method: 'get'
  });
}

/**
 * 修改社区
 * @param data
 */
export const updateCom = (data) => {
  return request({
    url: '/zjk-api/learningCommunity/update',
    method: 'post',
    data
  });
};



// 查询审批流程记录
export function listApproval(query: ResourceQuery): AxiosPromise<ResourceVO[]> {
  return request({
    url: '/zjk-api/approvalProcessLogs/list',
    method: 'get',
    params: query
  });
}

// 查询数据变更记录
export function listDataChange(query: ResourceQuery): AxiosPromise<[]> {
  return request({
    url: '/zjk-api/dataChangesLogs/list',
    method: 'get',
    params: query
  });
}

// 查询操作日志列表
export function list(query: ResourceQuery): AxiosPromise<ResourceVO[]> {
  return request({
    url: '/monitor/operlog/list',
    method: 'get',
    params: query
  });
}

// 删除操作日志
export function delOperlog(operId: string | number | Array<string | number>) {
  return request({
    url: '/monitor/operlog/' + operId,
    method: 'delete'
  });
}

// 清空操作日志
export function cleanOperlog() {
  return request({
    url: '/monitor/operlog/clean',
    method: 'delete'
  });
}
