import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { LearningInformationVO, LearningInformationForm, LearningInformationQuery } from '@/api/study/information/types';

/**
 * 查询资讯列表
 * @param query
 * @returns {*}
 */

export const listLearningInformation = (query?: LearningInformationQuery): AxiosPromise<LearningInformationVO[]> => {
  return request({
    url: '/zjk/learningInformation/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询资讯详细
 * @param id
 */
export const getLearningInformation = (id: string | number): AxiosPromise<LearningInformationVO> => {
  return request({
    url: '/zjk/learningInformation/' + id,
    method: 'get'
  });
};

/**
 * 新增资讯
 * @param data
 */
export const addLearningInformation = (data: LearningInformationForm) => {
  return request({
    url: '/zjk/learningInformation',
    method: 'post',
    data: data
  });
};

/**
 * 修改资讯状态
 * @param data
 */
export const updateStatus = (data: LearningInformationForm) => {
  return request({
    url: '/zjk/learningInformation/update/status',
    method: 'post',
    data: data
  });
};
/**
 * 修改资讯
 * @param data
 */
export const updateLearningInformation = (data: LearningInformationForm) => {
  return request({
    url: '/zjk/learningInformation/update',
    method: 'post',
    data: data
  });
};

/**
 * 删除资讯
 * @param id
 */
export const delLearningInformation = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk/learningInformation/deleted/' + id,
    method: 'get'
  });
};
