import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { LearningCourseVO, LearningCourseForm, LearningCourseQuery } from '@/api/study/lesson/types';

/**
 * 查询学习时长
 * @param query
 * @returns {*}
 */

export const learningCompliance = () => {
  return request({
    url: '/zjk-api/learningRecords/compliance',
    method: 'get',
  });
};

/**
 * 查询学习记录列表
 * @param query
 * @returns {*}
 */

export const listLearningRecord = (query) => {
  return request({
    url: '/zjk-api/learningRecords/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询课程列表
 * @param query
 * @returns {*}
 */

export const listLearningCourse = (query?: LearningCourseQuery): AxiosPromise<LearningCourseVO[]> => {
  return request({
    url: '/zjk/learningCourse/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询课程详细
 * @param id
 */
export const getLearningCourse = (id: string | number): AxiosPromise<LearningCourseVO> => {
  return request({
    url: '/zjk/learningCourse/' + id,
    method: 'get'
  });
};

/**
 * 新增课程
 * @param data
 */
export const addLearningCourse = (data: LearningCourseForm) => {
  return request({
    url: '/zjk/learningCourse',
    method: 'post',
    data: data
  });
};

/**
 * 修改课程
 * @param data
 */
export const updateLearningCourse = (data: LearningCourseForm) => {
  return request({
    url: '/zjk/learningCourse/update',
    method: 'post',
    data: data
  });
};

/**
 * 新增课程记录
 * @param data
 */
export const addLessonRecord = (data) => {
  return request({
    url: '/zjk-api/learningRecords/add',
    method: 'post',
    data: data
  });
};

/**
 * 删除课程
 * @param id
 */
export const delLearningCourse = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk/learningCourse/deleted/' + id,
    method: 'get'
  });
};
