import request from '@/utils/request';
import { AxiosPromise } from 'axios';

export const getBaseData = (): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/evaluate/stsNum',
    method: 'get'
  });
};
export const getChartData = (key): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/evaluate/stsChart',
    method: 'get',
    params: {
      rangeMonth: key
    }
  });
};
export const getListData = (query): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/evaluate/stsList',
    method: 'get',
    params: query
  });
};
