import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { stateTypes, formTypes } from './types';


export const getLeaveInfo = (id?: string): AxiosPromise<stateTypes> => {
  return request({
    url: `/zjk/leave/detail/${id}`,
    method: 'get',
  });
};

export const Approval = (data: formTypes) => {
  return request({
    url: '/zjk/leave',
    method: 'put',
    data: data
  });
};
