import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { LoginData, LoginResult, VerifyCodeResult, TenantInfo, LoginUrlInfo, getTokenTypes } from './types';
import { UserInfo } from '@/api/system/user/types';
import useUserStore from '@/store/modules/user';


/**
 * @param data {LoginData}
 * @returns
 */
export function login(data: LoginData): AxiosPromise<LoginResult> {
  const params = {
    ...data,
    clientId: data.clientId || useUserStore().client_id,
    grantType: data.grantType || 'password'
  };
  return request({
    url: '/auth/login',
    headers: {
      isToken: false,
      isEncrypt: true,
      repeatSubmit: false
    },
    method: 'post',
    data: params
  });
}

export function smsLogin(data: LoginData): AxiosPromise<LoginResult> {
  const params = {
    ...data,
    clientId: data.clientId || useUserStore().client_id,
    grantType: data.grantType || 'password'
  };
  return request({
    url: '/auth/sms/smsLogin',
    headers: {
      isToken: false,
      isEncrypt: true,
      repeatSubmit: false
    },
    method: 'post',
    data: params
  });
}
/**
 * 注销
 */
export function logout() {
  request({
    url: '/resource/sse/close',
    method: 'get'
  });
  return request({
    url: '/auth/logout',
    method: 'post'
  });
}

/**
 * 获取验证码
 */
export function getCodeImg(): AxiosPromise<VerifyCodeResult> {
  return request({
    url: '/auth/code',
    headers: {
      isToken: false
    },
    method: 'get',
    timeout: 20000
  });
}

// 获取用户详细信息
export function getInfo(): AxiosPromise<UserInfo> {
  return request({
    url: '/system/user/getInfo',
    method: 'get'
  });
}

// 获取租户列表
export function getTenantList(): AxiosPromise<TenantInfo> {
  return request({
    url: '/auth/tenant/list',
    headers: {
      isToken: false
    },
    method: 'get'
  });
}

// 获取统一认证登录地址
export function getLoginUrl(): AxiosPromise<LoginUrlInfo> {
  return request({
    url: '',
    headers: {
      isToken: false
    },
    method: 'get'
  });
}

// 发送goto地址
export function sendGotoUrl(data: string): AxiosPromise<string> {
  let params = {
    gotourl: data
  };
  return request({
    url: '/auth/goto-sxzwfw',
    headers: {
      isToken: false
    },
    method: 'get',
    params: params
  });
}

// 获取统一用户登录地址
export function getSXZWFWLoginToken(data: string): AxiosPromise<LoginResult> {
  return request({
    url: `/auth/userCenter/callback?${data}`,
    method: 'get'
  });
}

// 是否90天未修改密码
export function getPasswordSecure() {
  return request({
    url: `/system/user/passwordSecure`,
    method: 'get'
  });
}

