import request from '@/utils/request';
import { AxiosPromise } from 'axios';

export const getTableList = (query?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/point/pointDetail',
    method: 'get',
    params: query
  });
};
export const ReviewPoints = (query: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/point/pointCheck',
    method: 'post',
    data: query
  });
};

export const getReviewInfoById = (id?: any): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/point/pointCheckDetail`,
    method: 'get',
    params: {
      expertId: id
    }
  });
};

export const deleteLog = (query: any): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/point/deleteRecord/${query.id}`,
    method: 'get',
    params: query
  });
};

export const getChartData = (query?: any): AxiosPromise<any> => {
  return request({
    url: '/zjk-api/point/pointTrend',
    method: 'get',
    params: query
  });
};
