import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { ExpertVO, ExpertForm, ExpertQuery } from '@/api/expert/expert/types';

/**
 * 查询expert列表
 * @param query
 * @returns {*}
 */

export const listExpert = (query?: ExpertQuery): AxiosPromise<ExpertVO[]> => {
  return request({
    url: '/zjk-api/expert/expertList',
    method: 'get',
    params: query
  });
};

/**
 * 查询expert详细
 * @param id
 */
export const getExpert = (id: string | number): AxiosPromise<ExpertVO> => {
  return request({
    url: '/zjk-api/expert/' + id,
    method: 'get'
  });
};

/**
 * 新增expert
 * @param data
 */
export const addExpert = (data: ExpertForm) => {
  return request({
    url: '/zjk-api/expert/save',
    method: 'post',
    data: data
  });
};

/**
 * 修改expert
 * @param data
 */
export const updateExpert = (data: ExpertForm) => {
  return request({
    url: '/zjk-api/expert/update',
    method: 'post',
    data: data
  });
};

/**
 * 删除expert
 * @param id
 */
export const delExpert = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk-api/expert/delete/' + id,
    method: 'get'
  });
};
