import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { ProjectVO, ProjectForm, ProjectQuery } from '@/api/project/maintain/types';

/**
 * 查询【请填写功能名称】列表
 * @param query
 * @returns {*}
 */

export const listProject = (query?: ProjectQuery): AxiosPromise<ProjectVO[]> => {
  return request({
    url: '/zjk/product/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询项目详细
 * @param id
 */
export const getProject = (id: string | number): AxiosPromise<ProjectVO> => {
  return request({
    url: '/zjk/product/' + id,
    method: 'get'
  });
};
/**
 * 查询【请填写功能名称】详细
 * @param revision
 */
// export const getProject = (revision: string | number): AxiosPromise<ProjectVO> => {
//   return request({
//     url: '/zjk/product/' + revision,
//     method: 'get'
//   });
// };

/**
 * 新增【请填写功能名称】
 * @param data
 */
export const addProject = (data: ProjectForm) => {
  return request({
    url: '/zjk/product',
    method: 'post',
    data: data
  });
};

/**
 * 修改【请填写功能名称】
 * @param data
 */
export const updateProject = (data: ProjectForm) => {
  return request({
    url: '/zjk/product/update',
    method: 'post',
    data: data
  });
};

/**
 * 删除【请填写功能名称】
 * @param revision
 */
export const delProject = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk/product/delete/' + id,
    method: 'get'
  });
};

// 查询操作日志详情
export function verifyHmac(query: {
  bizType: string
  id: string | number
  fields?: string[]
}): AxiosPromise<any> {
  return request({
    url: '/zjk/hmac/verifyHmac',
    method: 'post',
    data: query
  }).then(res => res.data);
}
