import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { SummarizeVO, SummarizeQuery } from './types';

export const listSummarize = (query?: SummarizeVO): AxiosPromise<SummarizeQuery[]> => {
  return request({
    url: '/zjk-api/productSummarize/list',
    method: 'get',
    params: query
  });
};

// 获取项目列表
export const getProjectSelList = (): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/product/get-product`,
    method: 'get'
  });
};
// 获取选中项目阶段
export const getStage = (id?: string): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/product/get-product-review`,
    method: 'get',
    params: {
      productId: id
    }
  });
};
// 获取专家列表
export const getExpertSelList = (): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/expert/querylist`,
    method: 'get'
  });
};
export const SummarizeAddAjax = (query: any): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/productSummarize`,
    method: 'post',
    data: query
  });
};
export const SummarizeUpdateAjax = (query: any): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/productSummarize/update`,
    method: 'post',
    data: query
  });
};

export const getSummarizeInfo = (id: string): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/productSummarize/${id}`,
    method: 'get'
  });
};
export const getSummarizeLogInfo = (id: string): AxiosPromise<any> => {
  return request({
    url: `/zjk-api/productSummarizeLog/${id}`,
    method: 'get'
  });
};

export const getAuditList = (query?: any): AxiosPromise<any[]> => {
  return request({
    url: '/zjk-api/productSummarizeLog/list',
    method: 'get',
    params: query
  });
};

export const AuditSummarize = (query?: any): AxiosPromise<any[]> => {
  return request({
    url: `/zjk-api/productSummarizeLog/audit`,
    method: 'post',
    data: query
  });
};

export const getExperts = (id?: string): AxiosPromise<any[]> => {
  return request({
    url: `/zjk-api/productSummarize/get-expert-by-review-id`,
    method: 'get',
    params: {
      reviewId: id
    }
  });
};
export const getProductPaperFiles = (query?: any): AxiosPromise<any[]> => {
  return request({
    url: `/zjk-api/expertPaper/paper/list`,
    method: 'get',
    params: query
  });
};
export const getProductPatentFiles = (query?: any): AxiosPromise<any[]> => {
  return request({
    url: `/zjk-api/expertPatent/patent/list`,
    method: 'get',
    params: query
  });
};

export const setEvaluate = (query?: any): AxiosPromise<any[]> => {
  return request({
    url: `/zjk-api/projectEvaluation/insert`,
    method: 'post',
    data: query
  });
};
