export interface LearningCourseVO {
  /**
   * id
   */
  id: string | number;

  /**
   * 课程名称
   */
  courseName: string;

  /**
   * 课程分类
   */
  courseClassify: string;

  /**
   * 授课方式
   */
  teachingType: string;

  /**
   * 课程简介
   */
  courseBrief: string;

  /**
   * 课程图片
   */
  coursePic: string;

  /**
   * 课程图片Url
   */
  coursePicUrl: string;
  /**
   * 状态
   */
  status: string;

  /**
   * 备注
   */
  remark: string;

  /**
   * 附件
   */
  courseAttachment: string;
  originalName?: string;
  url?:string
}

export interface LearningCourseForm extends BaseEntity {
  /**
   * id
   */
  id?: string | number;

  /**
   * 课程名称
   */
  courseName?: string;

  /**
   * 课程分类
   */
  courseClassify?: string;

  /**
   * 授课方式
   */
  teachingType?: string;

  /**
   * 课程简介
   */
  courseBrief?: string;

  /**
   * 课程图片
   */
  coursePic?: string;

  /**
   * 状态
   */
  status?: string;

  /**
   * 备注
   */
  remark?: string;

  /**
   * 附件
   */
  courseAttachment?: string;

}

export interface LearningCourseQuery extends PageQuery {

  /**
   * 课程名称
   */
  courseName?: string;

  /**
   * 课程分类
   */
  courseClassify?: string;

  /**
   * 授课方式
   */
  teachingType?: string;

  /**
   * 状态
   */
  status?: string;

  /**
   * 附件
   */
  courseAttachment?: string;

    /**
     * 日期范围参数
     */
    params?: any;
}



