import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { PlanVO } from './types';

interface paramsQuery {
  pageNum: string | number;
  pageSize: number;
  planName: string | number
}
export const getPlanList = (query?: paramsQuery): AxiosPromise<PlanVO[]> => {
  return request({
    url: '/zjk/learningPlan/list',
    method: 'get',
    params: query
  });
};
export const getPlanById = (id:string | number): AxiosPromise<PlanVO> => {
  return request({
    url: '/zjk/learningPlan/' + id,
    method: 'get',
  });
};


export const PlanSubmit = (data: any) => {
  return request({
    url: '/zjk/learningPlan/add',
    method: 'post',
    data: data
  });
};

export const delPlan = (id: string | number) => {
  return request({
    url: '/zjk/learningPlan/delete/' + id,
    method: 'get'
  });
}