import request from '@/utils/request';
import { AxiosPromise } from 'axios';

interface paramsQuery {
  pageNum: string | number;
  pageSize: number;
  expertName: string;
  content: string;
}
export const getRecommendList = (query?: paramsQuery): AxiosPromise<any[]> => {
  return request({
    url: '/zjk/learningSuggest/list',
    method: 'get',
    params: query
  });
};
export const getLogs = (): AxiosPromise<any[]> => {
  return request({
    url: '/zjk/learningSuggest/myList',
    method: 'get',
  });
};


export const setRecommend = (data: any) => {
  return request({
    url: '/zjk/learningSuggest/add',
    method: 'post',
    data: data
  });
};

export const delRecommend = (id: string | number) => {
  return request({
    url: '/zjk/learningSuggest/delete/' + id,
    method: 'get'
  });
}
