import request from '@/utils/request';
import { AxiosPromise } from 'axios';
import { LearningToolVO, LearningToolForm, LearningToolQuery } from '@/api/study/tool/types';

/**
 * 查询学习工具管理列表
 * @param query
 * @returns {*}
 */

export const listLearningTool = (query?: LearningToolQuery): AxiosPromise<LearningToolVO[]> => {
  return request({
    url: '/zjk/learningTool/list',
    method: 'get',
    params: query
  });
};

/**
 * 查询学习工具管理详细
 * @param id
 */
export const getLearningTool = (id: string | number): AxiosPromise<LearningToolVO> => {
  return request({
    url: '/zjk/learningTool/' + id,
    method: 'get'
  });
};

/**
 * 新增学习工具管理
 * @param data
 */
export const addLearningTool = (data: LearningToolForm) => {
  return request({
    url: '/zjk/learningTool',
    method: 'post',
    data: data
  });
};

/**
 * 修改学习工具管理
 * @param data
 */
export const updateStatus = (data: LearningToolForm) => {
  return request({
    url: '/zjk/learningTool/update-status',
    method: 'post',
    data: data
  });
};
/**
 * 修改学习工具管理
 * @param data
 */
export const updateLearningTool = (data: LearningToolForm) => {
  return request({
    url: '/zjk/learningTool/update',
    method: 'post',
    data: data
  });
};

/**
 * 删除学习工具管理
 * @param id
 */
export const delLearningTool = (id: string | number | Array<string | number>) => {
  return request({
    url: '/zjk/learningTool/deleted/' + id,
    method: 'get'
  });
};
