// 手机号验证
// export const isPhone = /^[1][3,4,5,6,7,8,9][0-9]{9}$/;
export const isPhone = /^[1][3,4,5,6,7,8,9][0-9]{9}$|^0\d{2,3}-?\d{7,8}$/;

// 密码验证  长度在6-24之间，必须包含大写字母、小写字母和数字
export const isPassword = /^.*(?=.{6,24})(?=.*\d)(?=.*[A-Z]{1,})(?=.*[a-z]{1,}).*$/;

// 车牌号验证
export const isVehiclesNum = /^([京津沪渝冀豫云辽黑湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领A-Z]{1}[a-zA-Z](([DF]((?![IO])[a-zA-Z0-9](?![IO]))[0-9]{4})|([0-9]{5}[DF]))|[京津沪渝冀豫云辽黑湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领A-Z]{1}[A-Z]{1}[A-Z0-9]{4}[A-Z0-9挂学警港澳]{1})$/;

// 身份证验证
export const isIdCard = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;

// 验证邮箱
export const isEmail = /^([a-zA-Z]|[0-9])(\w|-)+@[a-zA-Z0-9]+\.([a-zA-Z]{2,4})$/;

// 只能是中文
// export const isChinese = /^[\u0391-\uFFE5]+$/;
export const isChinese = /^[\u4E00-\u9FA5]+$/;

// 不能是中文 只能输入数字字母下划线
export const noChinese = /^[0-9a-zA-Z-_./:]+$/;

//不能包含中文
export const noIncludeChinese = /^[^\u4E00-\u9FA5]+$/;

// 只能是字母
export const isLetter = /^[a-zA-Z]+$/;

// 只能是数字
export const isNumber = /^[0-9]+$/;

// 只能是字母和数字
export const isNumberLetter = /^[0-9a-zA-Z]+$/;

// 图片验证
export const isImage = /\.(png|jpg|gif|jpeg|webp)$/;

// 视频验证
export const isVideo = /\.mp4/ig;

// 是否是超链接
export const isExternal = /^(https?:|mailto:|tel:)/;

// 是否是PDF
export const pdfReg = /^.+(\.pdf)$/;

// 是否是word
export const wordReg = /^.+(\.doc|\.docx)$/;

// 是否是excel
export const excelReg = /^.+(\.xls|\.xlsx)$/;

// 统一社会信用代码校验
export const isScc = /^([0-9A-HJ-NPQRTUWXY]{2}\d{6}[0-9A-HJ-NPQRTUWXY]{10}|[1-9]\d{14})$/;

//ip校验
export const isIp = /^(\d|[1-9]\d|1\d{2}|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d{2}|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d{2}|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d{2}|2[0-4]\d|25[0-5])$/

//端口校验
export const isPort = /^([0-9]|[1-9]\d{1,3}|[1-5]\d{4}|6[0-4]\d{4}|65[0-4]\d{2}|655[0-2]\d|6553[0-5])$/

//ip或域名
export const isIpOrDomain = /(^((?:(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(?:(\/([1-9]|[1-2]\d|3[0-1]))|(\-((?:(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))))?)|((?:(?:[a-zZ-Z0-9]+)\.){2}((com|org|net)\.)?(com|cn|net|org|biz|info|cc|tv|top|vip)))(\;((?:(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(?:(\/([1-9]|[1-2]\d|3[0-1]))|(\-((?:(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}(?:[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))))?|((?:(?:[a-zZ-Z0-9]+)\.){2}((com|org|net)\.)?(com|cn|net|org|biz|info|cc|tv|top|vip))))*$/